/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.booter.spi;

import java.io.IOException;
import java.net.MalformedURLException;
import javax.annotation.Nonnull;
import org.apache.maven.surefire.api.booter.MasterProcessChannelDecoder;
import org.apache.maven.surefire.api.booter.MasterProcessChannelEncoder;
import org.apache.maven.surefire.api.fork.ForkNodeArguments;
import org.apache.maven.surefire.api.util.internal.Channels;
import org.apache.maven.surefire.api.util.internal.WritableBufferedByteChannel;
import org.apache.maven.surefire.booter.spi.AbstractMasterProcessChannelProcessorFactory;
import org.apache.maven.surefire.booter.spi.CommandChannelDecoder;
import org.apache.maven.surefire.booter.spi.EventChannelEncoder;

public class LegacyMasterProcessChannelProcessorFactory
extends AbstractMasterProcessChannelProcessorFactory {
    private static final int FLUSH_PERIOD_MILLIS = 100;

    @Override
    public boolean canUse(String channelConfig) {
        return channelConfig.startsWith("pipe://");
    }

    @Override
    public void connect(String channelConfig) throws IOException {
        if (!this.canUse(channelConfig)) {
            throw new MalformedURLException("Unknown channel string " + channelConfig);
        }
    }

    @Override
    public MasterProcessChannelDecoder createDecoder(@Nonnull ForkNodeArguments forkingArguments) {
        return new CommandChannelDecoder(Channels.newBufferedChannel(System.in), forkingArguments);
    }

    @Override
    public MasterProcessChannelEncoder createEncoder(@Nonnull ForkNodeArguments forkingArguments) {
        WritableBufferedByteChannel channel = Channels.newBufferedChannel(System.out);
        this.schedulePeriodicFlusher(100, channel);
        return new EventChannelEncoder(channel);
    }
}

