/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.booter;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.maven.surefire.api.cli.CommandLineOption;
import org.apache.maven.surefire.api.provider.CommandChainReader;
import org.apache.maven.surefire.api.provider.ProviderParameters;
import org.apache.maven.surefire.api.report.ReporterConfiguration;
import org.apache.maven.surefire.api.report.ReporterFactory;
import org.apache.maven.surefire.api.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.api.testset.RunOrderParameters;
import org.apache.maven.surefire.api.testset.TestArtifactInfo;
import org.apache.maven.surefire.api.testset.TestRequest;
import org.apache.maven.surefire.api.util.DefaultDirectoryScanner;
import org.apache.maven.surefire.api.util.DefaultRunOrderCalculator;
import org.apache.maven.surefire.api.util.DefaultScanResult;
import org.apache.maven.surefire.api.util.DirectoryScanner;
import org.apache.maven.surefire.api.util.RunOrderCalculator;
import org.apache.maven.surefire.api.util.ScanResult;

public class BaseProviderFactory
implements ProviderParameters {
    private final boolean insideFork;
    private ReporterFactory reporterFactory;
    private List<CommandLineOption> mainCliOptions = Collections.emptyList();
    private Map<String, String> providerProperties;
    private DirectoryScannerParameters directoryScannerParameters;
    private ReporterConfiguration reporterConfiguration;
    private RunOrderParameters runOrderParameters;
    private ClassLoader testClassLoader;
    private TestRequest testRequest;
    private TestArtifactInfo testArtifactInfo;
    private int skipAfterFailureCount;
    private Integer systemExitTimeout;
    private CommandChainReader commandReader;

    public BaseProviderFactory(boolean insideFork) {
        this.insideFork = insideFork;
    }

    @Override
    public CommandChainReader getCommandReader() {
        return this.commandReader;
    }

    public void setCommandReader(CommandChainReader commandReader) {
        this.commandReader = commandReader;
    }

    @Override
    @Deprecated
    public DirectoryScanner getDirectoryScanner() {
        return this.directoryScannerParameters == null ? null : new DefaultDirectoryScanner(this.directoryScannerParameters.getTestClassesDirectory(), this.directoryScannerParameters.getIncludes(), this.directoryScannerParameters.getExcludes(), this.directoryScannerParameters.getSpecificTests());
    }

    @Override
    public ScanResult getScanResult() {
        return DefaultScanResult.from(this.providerProperties);
    }

    private int getThreadCount() {
        String threadcount = this.providerProperties.get("threadcount");
        return threadcount == null ? 1 : Math.max(Integer.parseInt(threadcount), 1);
    }

    @Override
    public RunOrderCalculator getRunOrderCalculator() {
        return new DefaultRunOrderCalculator(this.runOrderParameters, this.getThreadCount());
    }

    public void setReporterFactory(ReporterFactory reporterFactory) {
        this.reporterFactory = reporterFactory;
    }

    @Override
    public ReporterFactory getReporterFactory() {
        return this.reporterFactory;
    }

    public void setDirectoryScannerParameters(DirectoryScannerParameters directoryScannerParameters) {
        this.directoryScannerParameters = directoryScannerParameters;
    }

    public void setReporterConfiguration(ReporterConfiguration reporterConfiguration) {
        this.reporterConfiguration = reporterConfiguration;
    }

    public void setClassLoaders(ClassLoader testClassLoader) {
        this.testClassLoader = testClassLoader;
    }

    public void setTestRequest(TestRequest testRequest) {
        this.testRequest = testRequest;
    }

    @Override
    public DirectoryScannerParameters getDirectoryScannerParameters() {
        return this.directoryScannerParameters;
    }

    @Override
    public ReporterConfiguration getReporterConfiguration() {
        return this.reporterConfiguration;
    }

    @Override
    public TestRequest getTestRequest() {
        return this.testRequest;
    }

    @Override
    public ClassLoader getTestClassLoader() {
        return this.testClassLoader;
    }

    public void setProviderProperties(Map<String, String> providerProperties) {
        this.providerProperties = providerProperties;
    }

    @Override
    public Map<String, String> getProviderProperties() {
        return this.providerProperties;
    }

    @Override
    public TestArtifactInfo getTestArtifactInfo() {
        return this.testArtifactInfo;
    }

    public void setTestArtifactInfo(TestArtifactInfo testArtifactInfo) {
        this.testArtifactInfo = testArtifactInfo;
    }

    public void setRunOrderParameters(RunOrderParameters runOrderParameters) {
        this.runOrderParameters = runOrderParameters;
    }

    @Override
    public List<CommandLineOption> getMainCliOptions() {
        return this.mainCliOptions;
    }

    public void setMainCliOptions(List<CommandLineOption> mainCliOptions) {
        this.mainCliOptions = mainCliOptions == null ? Collections.emptyList() : mainCliOptions;
    }

    @Override
    public int getSkipAfterFailureCount() {
        return this.skipAfterFailureCount;
    }

    public void setSkipAfterFailureCount(int skipAfterFailureCount) {
        this.skipAfterFailureCount = skipAfterFailureCount;
    }

    @Override
    public boolean isInsideFork() {
        return this.insideFork;
    }

    @Override
    public Integer getSystemExitTimeout() {
        return this.systemExitTimeout;
    }

    public void setSystemExitTimeout(Integer systemExitTimeout) {
        this.systemExitTimeout = systemExitTimeout;
    }
}

