/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire.report;

import java.util.List;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugin.surefire.log.api.Level;
import org.apache.maven.plugin.surefire.report.TestSetStats;
import org.apache.maven.plugin.surefire.report.WrappedReportEntry;
import org.apache.maven.surefire.api.report.TestSetReportEntry;
import org.apache.maven.surefire.extensions.StatelessTestsetInfoConsoleReportEventListener;
import org.apache.maven.surefire.shared.utils.logging.MessageBuilder;
import org.apache.maven.surefire.shared.utils.logging.MessageUtils;

public class ConsoleReporter
extends StatelessTestsetInfoConsoleReportEventListener<WrappedReportEntry, TestSetStats> {
    public static final String BRIEF = "brief";
    public static final String PLAIN = "plain";
    private static final String TEST_SET_STARTING_PREFIX = "Running ";
    private final boolean usePhrasedClassNameInRunning;
    private final boolean usePhrasedClassNameInTestCaseSummary;

    public ConsoleReporter(ConsoleLogger logger, boolean usePhrasedClassNameInRunning, boolean usePhrasedClassNameInTestCaseSummary) {
        super(logger);
        this.usePhrasedClassNameInRunning = usePhrasedClassNameInRunning;
        this.usePhrasedClassNameInTestCaseSummary = usePhrasedClassNameInTestCaseSummary;
    }

    @Override
    public void testSetStarting(TestSetReportEntry report) {
        MessageBuilder builder = MessageUtils.buffer().a(TEST_SET_STARTING_PREFIX);
        String runningTestCase = TestSetStats.concatenateWithTestGroup(builder, report, this.usePhrasedClassNameInRunning);
        this.getConsoleLogger().info(runningTestCase);
    }

    @Override
    public void testSetCompleted(WrappedReportEntry report, TestSetStats testSetStats, List<String> testResults) {
        boolean success = testSetStats.getCompletedCount() > 0;
        boolean failures = testSetStats.getFailures() > 0;
        boolean errors = testSetStats.getErrors() > 0;
        boolean skipped = testSetStats.getSkipped() > 0;
        boolean flakes = testSetStats.getSkipped() > 0;
        Level level = Level.resolveLevel(success, failures, errors, skipped, flakes);
        this.println(testSetStats.getColoredTestSetSummary(report, this.usePhrasedClassNameInTestCaseSummary), level);
        for (String testResult : testResults) {
            this.println(testResult, level);
        }
    }

    @Override
    public void reset() {
    }

    private void println(String message, Level level) {
        switch (level) {
            case FAILURE: {
                this.getConsoleLogger().error(message);
                break;
            }
            case UNSTABLE: {
                this.getConsoleLogger().warning(message);
                break;
            }
            default: {
                this.getConsoleLogger().info(message);
            }
        }
    }
}

