/*
 * Decompiled with CFR 0.152.
 */
package com.desoteric.builder.service;

import com.desoteric.builder.Config;
import com.desoteric.builder.ExecutionInput;
import com.desoteric.builder.ExecutionServiceKt;
import com.desoteric.builder.FileTree;
import com.desoteric.builder.FileTreeBuilder;
import com.desoteric.builder.config.properties.CompilerConfigurationProperties;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.path.PathsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.help.HelpFormatter;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001b\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0016\u00a2\u0006\u0002\u0010\"J\b\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u001eH\u0016J\u0010\u0010(\u001a\u00020)2\u0006\u0010'\u001a\u00020\u001eH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000f\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0012\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0015\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0017\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0018\u001a\n \f*\u0004\u0018\u00010\u000e0\u000eX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lcom/desoteric/builder/service/CompilerHelper;", "", "compilerConfigurationProperties", "Lcom/desoteric/builder/config/properties/CompilerConfigurationProperties;", "fileTreeBuilder", "Lcom/desoteric/builder/FileTreeBuilder;", "projectCompilerConfiguration", "Lcom/desoteric/builder/Config;", "<init>", "(Lcom/desoteric/builder/config/properties/CompilerConfigurationProperties;Lcom/desoteric/builder/FileTreeBuilder;Lcom/desoteric/builder/Config;)V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "version", "Lorg/apache/commons/cli/Option;", "outputDirectory", "classPath", "sourcePath", "generatedSourceFileDirectory", "generateDebugging", "target", "source", "release", "encoding", "proc", "options", "Lorg/apache/commons/cli/Options;", "parser", "Lorg/apache/commons/cli/DefaultParser;", "parse", "Lorg/apache/commons/cli/CommandLine;", "args", "", "", "([Ljava/lang/String;)Lorg/apache/commons/cli/CommandLine;", "printHelp", "", "getOutputDirectory", "Ljava/nio/file/Path;", "commandLine", "createExecutionInput", "Lcom/desoteric/builder/ExecutionInput;", "compiler"})
@SourceDebugExtension(value={"SMAP\nCompilerHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerHelper.kt\ncom/desoteric/builder/service/CompilerHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,190:1\n774#2:191\n865#2,2:192\n1563#2:194\n1634#2,3:195\n774#2:198\n865#2,2:199\n1563#2:201\n1634#2,3:202\n1285#2,2:205\n1299#2,4:207\n774#2:211\n865#2,2:212\n1563#2:214\n1634#2,3:215\n774#2:218\n865#2,2:219\n1563#2:221\n1634#2,3:222\n1563#2:229\n1634#2,3:230\n1563#2:233\n1634#2,3:234\n1563#2:237\n1634#2,3:238\n1563#2:241\n1634#2,3:242\n11561#3:225\n11896#3,3:226\n*S KotlinDebug\n*F\n+ 1 CompilerHelper.kt\ncom/desoteric/builder/service/CompilerHelper\n*L\n89#1:191\n89#1:192,2\n89#1:194\n89#1:195,3\n91#1:198\n91#1:199,2\n91#1:201\n91#1:202,3\n94#1:205,2\n94#1:207,4\n103#1:211\n103#1:212,2\n104#1:214\n104#1:215,3\n112#1:218\n112#1:219,2\n112#1:221\n112#1:222,3\n123#1:229\n123#1:230,3\n130#1:233\n130#1:234,3\n170#1:237\n170#1:238,3\n176#1:241\n176#1:242,3\n120#1:225\n120#1:226,3\n*E\n"})
public class CompilerHelper {
    @NotNull
    private final CompilerConfigurationProperties compilerConfigurationProperties;
    @NotNull
    private final FileTreeBuilder fileTreeBuilder;
    @NotNull
    private final Config projectCompilerConfiguration;
    private final Logger logger;
    private final Option version;
    private final Option outputDirectory;
    private final Option classPath;
    private final Option sourcePath;
    private final Option generatedSourceFileDirectory;
    private final Option generateDebugging;
    private final Option target;
    private final Option source;
    private final Option release;
    private final Option encoding;
    private final Option proc;
    @NotNull
    private final Options options;
    @NotNull
    private final DefaultParser parser;

    public CompilerHelper(@NotNull CompilerConfigurationProperties compilerConfigurationProperties, @NotNull FileTreeBuilder fileTreeBuilder, @NotNull Config projectCompilerConfiguration) {
        Intrinsics.checkNotNullParameter((Object)compilerConfigurationProperties, (String)"compilerConfigurationProperties");
        Intrinsics.checkNotNullParameter((Object)fileTreeBuilder, (String)"fileTreeBuilder");
        Intrinsics.checkNotNullParameter((Object)projectCompilerConfiguration, (String)"projectCompilerConfiguration");
        this.compilerConfigurationProperties = compilerConfigurationProperties;
        this.fileTreeBuilder = fileTreeBuilder;
        this.projectCompilerConfiguration = projectCompilerConfiguration;
        this.logger = LoggerFactory.getLogger(CompilerHelper.class);
        this.version = Option.builder().option("version").get();
        this.outputDirectory = Option.builder().option("d").hasArg().argName("directory").get();
        this.classPath = Option.builder().option("cp").hasArg().longOpt("classpath").argName("path").get();
        this.sourcePath = Option.builder().option("sourcepath").hasArg().argName("path").get();
        this.generatedSourceFileDirectory = Option.builder().option("s").hasArg().argName("directory").get();
        this.generateDebugging = Option.builder().option("g").get();
        this.target = Option.builder().option("target").hasArg().argName("release").get();
        this.source = Option.builder().option("source").hasArg().argName("release").get();
        this.release = Option.builder().option("release").longOpt("release").hasArg().argName("release").get();
        this.encoding = Option.builder().option("encoding").hasArg().argName("encoding").get();
        this.proc = Option.builder().longOpt("proc").valueSeparator(':').hasArg().get();
        Options options = new Options().addOption(this.version).addOption(this.outputDirectory).addOption(this.classPath).addOption(this.sourcePath).addOption(this.generatedSourceFileDirectory).addOption(this.generateDebugging).addOption(this.target).addOption(this.source).addOption(this.release).addOption(this.encoding).addOption(this.proc);
        Intrinsics.checkNotNullExpressionValue((Object)options, (String)"addOption(...)");
        this.options = options;
        this.parser = new DefaultParser();
    }

    @NotNull
    public CommandLine parse(@NotNull String[] args) {
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.logger.info("Parsing arguments {}", (Object)ArraysKt.joinToString$default((Object[])args, (CharSequence)" ", null, null, (int)0, null, null, (int)62, null));
        CommandLine commandLine = this.parser.parse(this.options, args);
        Intrinsics.checkNotNullExpressionValue((Object)commandLine, (String)"parse(...)");
        return commandLine;
    }

    public void printHelp() {
        HelpFormatter helpFormatter = HelpFormatter.builder().get();
        helpFormatter.printHelp("compiler", "Header", this.options, "Footer", true);
    }

    @NotNull
    public Path getOutputDirectory(@NotNull CommandLine commandLine) {
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Path path = Optional.ofNullable(commandLine.getOptionValue(this.outputDirectory)).map(arg_0 -> CompilerHelper.getOutputDirectory$lambda$1(CompilerHelper::getOutputDirectory$lambda$0, arg_0)).orElse(Path.of("", new String[0]));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"orElse(...)");
        return path;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ExecutionInput createExecutionInput(@NotNull CommandLine commandLine) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Iterable $this$mapTo$iv$iv2;
        void $this$mapTo$iv$iv3;
        Path it;
        void $this$mapTo$iv$iv4;
        void $this$mapTo$iv$iv5;
        void $this$map$iv2;
        void $this$filterTo$iv$iv;
        void $this$mapTo$iv$iv6;
        void $this$map$iv3;
        void $this$filterTo$iv$iv2;
        Path it2;
        Object object;
        Iterable $this$associateWithTo$iv$iv;
        void $this$mapTo$iv$iv7;
        void $this$map$iv4;
        void $this$filterTo$iv$iv3;
        Object object2;
        void $this$mapTo$iv$iv8;
        void $this$map$iv5;
        String it3;
        void $this$filterTo$iv$iv4;
        Intrinsics.checkNotNullParameter((Object)commandLine, (String)"commandLine");
        Path workingDirectory = Path.of(System.getProperty("user.dir"), new String[0]);
        Path sandboxWorkingDirectory = this.compilerConfigurationProperties.getWorkingDirectoryPath();
        this.logger.info("Sandbox working directory {}", (Object)sandboxWorkingDirectory);
        FileTree inputFileTrees = this.fileTreeBuilder.buildFileTree(CollectionsKt.toList((Iterable)this.projectCompilerConfiguration.getInclude().values()));
        if (commandLine.hasOption(this.version)) {
            String[] stringArray = new String[]{this.compilerConfigurationProperties.getExecutable(), "-version"};
            List list = CollectionsKt.listOf((Object[])stringArray);
            Object object3 = new FileTree[]{inputFileTrees};
            stringArray = ExecutionServiceKt.mergeFileTrees((FileTree[])object3);
            object3 = this.projectCompilerConfiguration.getEnvironment();
            boolean bl = this.compilerConfigurationProperties.getDoNotCache();
            return new ExecutionInput(list, (FileTree)stringArray, null, bl, (Map)object3, "", 4, null);
        }
        Path sandboxOutputDirectory = Path.of(this.compilerConfigurationProperties.getOutputDirectory(), new String[0]);
        String string = commandLine.getOptionValue(this.classPath, "");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getOptionValue(...)");
        char[] cArray = new char[]{':'};
        Iterable $this$filter$iv = StringsKt.split$default((CharSequence)string, (char[])cArray, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Iterable destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv4) {
            it3 = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)it3);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map22 = false;
        $this$filterTo$iv$iv4 = $this$map$iv5;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv5, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv8) {
            it3 = (String)item$iv$iv;
            object2 = destination$iv$iv;
            boolean bl = false;
            object2.add(Path.of(it3, new String[0]));
        }
        List classPaths = (List)destination$iv$iv;
        String string2 = commandLine.getOptionValue(this.sourcePath, "");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getOptionValue(...)");
        char[] $i$f$map22 = new char[]{':'};
        Iterable $this$filter$iv2 = StringsKt.split$default((CharSequence)string2, (char[])$i$f$map22, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$filter2 = false;
        destination$iv$iv = $this$filter$iv2;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo2 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv3) {
            String it4 = (String)element$iv$iv;
            boolean bl = false;
            boolean bl3 = !StringsKt.isBlank((CharSequence)it4);
            if (!bl3) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv2 = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv3 = $this$map$iv4;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv4, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv7) {
            String it4 = (String)item$iv$iv;
            object2 = destination$iv$iv2;
            boolean bl = false;
            object2.add(Path.of(it4, new String[0]));
        }
        List sourcePaths = (List)destination$iv$iv2;
        Iterable $this$associateWith$iv = sourcePaths;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $i$f$mapTo22 = $this$associateWith$iv;
        Object destination$iv$iv3 = result$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Path path = (Path)element$iv$iv;
            object = element$iv$iv;
            object2 = destination$iv$iv3;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)workingDirectory);
            Path path2 = this.fileTreeBuilder.getRemotePath(workingDirectory, sandboxWorkingDirectory, it2);
            object2.put(object, path2);
        }
        Map sandboxSourcePaths = destination$iv$iv3;
        Iterable $this$filter$iv3 = sourcePaths;
        boolean $i$f$filter3 = false;
        $this$associateWithTo$iv$iv = $this$filter$iv3;
        destination$iv$iv3 = new ArrayList();
        boolean $i$f$filterTo3 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv2) {
            it2 = (Path)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it2);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(it2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            destination$iv$iv3.add(element$iv$iv);
        }
        $this$filter$iv3 = (List)destination$iv$iv3;
        boolean $i$f$map3 = false;
        $this$filterTo$iv$iv2 = $this$map$iv3;
        destination$iv$iv3 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv3, (int)10));
        boolean $i$f$mapTo3 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv6) {
            void sourcePath;
            it2 = (Path)item$iv$iv;
            object2 = destination$iv$iv3;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)workingDirectory);
            Intrinsics.checkNotNull((Object)sourcePath);
            object2.add(this.fileTreeBuilder.buildFileTree(workingDirectory, sandboxWorkingDirectory, (Path)sourcePath));
        }
        List sourcePathFileTree = (List)destination$iv$iv3;
        Iterable $this$filter$iv4 = classPaths;
        boolean $i$f$filter4 = false;
        destination$iv$iv3 = $this$filter$iv4;
        Object[] destination$iv$iv4 = (Object[])new ArrayList();
        boolean $i$f$filterTo4 = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Path it5 = (Path)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it5);
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (!Files.exists(it5, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
            destination$iv$iv4.add(element$iv$iv);
        }
        $this$filter$iv4 = (List)destination$iv$iv4;
        boolean $i$f$map4 = false;
        $this$filterTo$iv$iv = $this$map$iv2;
        destination$iv$iv4 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo4 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv5) {
            Path it5 = (Path)item$iv$iv;
            object2 = destination$iv$iv4;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)workingDirectory);
            Intrinsics.checkNotNull((Object)it5);
            object2.add(this.fileTreeBuilder.buildFileTree(workingDirectory, sandboxWorkingDirectory, it5));
        }
        FileTree classPathFileTree = ExecutionServiceKt.mergeFileTrees((List)((List)destination$iv$iv4));
        String[] stringArray = commandLine.getArgs();
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"getArgs(...)");
        Object[] $this$map$iv6 = stringArray;
        boolean $i$f$map5 = false;
        destination$iv$iv4 = $this$map$iv6;
        Iterable destination$iv$iv5 = new ArrayList($this$map$iv6.length);
        boolean $i$f$mapTo5 = false;
        for (void item$iv$iv : $this$mapTo$iv$iv4) {
            String string3 = (String)item$iv$iv;
            object2 = destination$iv$iv5;
            boolean bl = false;
            object2.add(Path.of((String)((Object)it), new String[0]));
        }
        List sourceFiles = (List)destination$iv$iv5;
        Iterable $this$map$iv7 = sourceFiles;
        boolean $i$f$map6 = false;
        destination$iv$iv5 = $this$map$iv7;
        Iterable destination$iv$iv6 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv7, (int)10));
        boolean $i$f$mapTo6 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv3) {
            void sourceFile;
            it = (Path)item$iv$iv;
            object2 = destination$iv$iv6;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)workingDirectory);
            Intrinsics.checkNotNull((Object)sourceFile);
            object2.add(this.fileTreeBuilder.getRemotePath(workingDirectory, sandboxWorkingDirectory, (Path)sourceFile));
        }
        List sandboxSourceFiles = (List)destination$iv$iv6;
        Iterable $this$map$iv8 = sourceFiles;
        boolean $i$f$map72 = false;
        destination$iv$iv6 = $this$map$iv8;
        Collection destination$iv$iv7 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv8, (int)10));
        boolean $i$f$mapTo72 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it6;
            Path bl = (Path)item$iv$iv;
            object2 = destination$iv$iv7;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)workingDirectory);
            Path path = workingDirectory.resolve((Path)it6);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
            object2.add(this.fileTreeBuilder.buildFileTree(workingDirectory, sandboxWorkingDirectory, path));
        }
        List inputFiles = (List)destination$iv$iv7;
        List arguments = new ArrayList();
        if (!((Collection)classPaths).isEmpty()) {
            Object[] $i$f$map72 = new String[]{"-cp", CollectionsKt.joinToString$default((Iterable)classPaths, (CharSequence)":", null, null, (int)0, null, arg_0 -> CompilerHelper.createExecutionInput$lambda$12(this, workingDirectory, sandboxWorkingDirectory, arg_0), (int)30, null)};
            arguments.addAll(CollectionsKt.listOf((Object[])$i$f$map72));
        }
        if (commandLine.hasOption(this.source)) {
            Object[] $i$f$map72 = new String[]{"-source", commandLine.getOptionValue(this.source)};
            arguments.addAll(CollectionsKt.listOf((Object[])$i$f$map72));
        }
        if (commandLine.hasOption(this.target)) {
            Object[] $i$f$map72 = new String[]{"-target", commandLine.getOptionValue(this.target)};
            arguments.addAll(CollectionsKt.listOf((Object[])$i$f$map72));
        }
        if (commandLine.hasOption(this.release)) {
            Object[] $i$f$map72 = new String[]{"--release", commandLine.getOptionValue(this.release)};
            arguments.addAll(CollectionsKt.listOf((Object[])$i$f$map72));
        }
        if (commandLine.hasOption(this.encoding)) {
            Object[] $i$f$map72 = new String[]{"-encoding", commandLine.getOptionValue(this.encoding)};
            arguments.addAll(CollectionsKt.listOf((Object[])$i$f$map72));
        }
        if (commandLine.hasOption(this.sourcePath)) {
            Collection<Path> collection;
            void $this$mapTo$iv$iv9;
            void $this$map$iv9;
            Object[] $i$f$map72 = new String[2];
            $i$f$map72[0] = "-sourcepath";
            $this$mapTo$iv$iv2 = sandboxSourcePaths.values();
            int n = 1;
            object = $i$f$map72;
            object2 = arguments;
            boolean $i$f$map8 = false;
            void $i$f$mapTo72 = $this$map$iv9;
            Collection destination$iv$iv8 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv9, (int)10));
            boolean $i$f$mapTo8 = false;
            for (Object item$iv$iv2 : $this$mapTo$iv$iv9) {
                void it7;
                Path path = (Path)item$iv$iv2;
                collection = destination$iv$iv8;
                boolean bl = false;
                collection.add(PathsKt.relativeTo((Path)it7, (Path)sandboxWorkingDirectory));
            }
            collection = (List)destination$iv$iv8;
            object[n] = CollectionsKt.joinToString$default((Iterable)collection, (CharSequence)":", null, null, (int)0, null, null, (int)62, null);
            object2.addAll(CollectionsKt.listOf((Object[])$i$f$map72));
        }
        Object $i$f$map72 = new String[]{"-d", ((Object)sandboxOutputDirectory).toString()};
        arguments.addAll(CollectionsKt.listOf((Object[])$i$f$map72));
        $i$f$map72 = sandboxSourceFiles;
        object2 = arguments;
        boolean $i$f$map9 = false;
        void $i$f$map8 = $this$map$iv;
        Collection destination$iv$iv9 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo9 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it8;
            Path item$iv$iv2 = (Path)item$iv$iv;
            object = destination$iv$iv9;
            boolean bl = false;
            object.add((String)((Object)PathsKt.relativeTo((Path)it8, (Path)sandboxWorkingDirectory)).toString());
        }
        object2.addAll((List)destination$iv$iv9);
        List list = CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)this.compilerConfigurationProperties.getExecutable()), (Iterable)arguments);
        String string4 = StringsKt.removePrefix((String)((Object)sandboxWorkingDirectory).toString(), (CharSequence)"/");
        FileTree fileTree = ExecutionServiceKt.mergeFileTrees((List)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)inputFileTrees), (Iterable)sourcePathFileTree), (Object)classPathFileTree), (Iterable)inputFiles));
        List list2 = CollectionsKt.listOf((Object)((Object)sandboxOutputDirectory).toString());
        boolean bl = this.compilerConfigurationProperties.getDoNotCache();
        Map map = this.projectCompilerConfiguration.getEnvironment();
        ExecutionInput input = new ExecutionInput(list, fileTree, list2, bl, map, string4);
        return input;
    }

    private static final Path getOutputDirectory$lambda$0(String it) {
        return Path.of(it, new String[0]);
    }

    private static final Path getOutputDirectory$lambda$1(Function1 $tmp0, Object p0) {
        return (Path)$tmp0.invoke(p0);
    }

    private static final CharSequence createExecutionInput$lambda$12(CompilerHelper this$0, Path $workingDirectory, Path $sandboxWorkingDirectory, Path it) {
        FileTreeBuilder fileTreeBuilder = this$0.fileTreeBuilder;
        Intrinsics.checkNotNull((Object)$workingDirectory);
        Intrinsics.checkNotNull((Object)it);
        return ((Object)PathsKt.relativeTo((Path)fileTreeBuilder.getRemotePath($workingDirectory, $sandboxWorkingDirectory, it), (Path)$sandboxWorkingDirectory)).toString();
    }
}

