/*
 * Decompiled with CFR 0.152.
 */
package com.desoteric.builder.service;

import com.desoteric.builder.AnalyticsService;
import com.desoteric.builder.ExecutionInput;
import com.desoteric.builder.ExecutionOutput;
import com.desoteric.builder.ExecutionService;
import com.desoteric.builder.FileNodeTree;
import com.desoteric.builder.FileNodeTreeWriter;
import com.desoteric.builder.LicenseValidator;
import com.desoteric.builder.LicenseValidatorKt;
import com.desoteric.builder.ProjectConfiguration;
import com.desoteric.builder.Tool;
import com.desoteric.builder.config.properties.CompilerConfigurationProperties;
import com.desoteric.builder.service.CompilerHelper;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.apache.commons.cli.CommandLine;
import org.jetbrains.annotations.NotNull;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Service;

@Service
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ!\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140\u0013\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010\u0015R\u000e\u0010\u0002\u001a\u00020\u0003X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0092\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0092\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/desoteric/builder/service/CompilerCommandLineRunner;", "Lorg/springframework/boot/CommandLineRunner;", "executionService", "Lcom/desoteric/builder/ExecutionService;", "compilerHelper", "Lcom/desoteric/builder/service/CompilerHelper;", "compilerConfigurationProperties", "Lcom/desoteric/builder/config/properties/CompilerConfigurationProperties;", "projectConfiguration", "Lcom/desoteric/builder/ProjectConfiguration;", "fileNodeTreeWriter", "Lcom/desoteric/builder/FileNodeTreeWriter;", "analyticsService", "Lcom/desoteric/builder/AnalyticsService;", "<init>", "(Lcom/desoteric/builder/ExecutionService;Lcom/desoteric/builder/service/CompilerHelper;Lcom/desoteric/builder/config/properties/CompilerConfigurationProperties;Lcom/desoteric/builder/ProjectConfiguration;Lcom/desoteric/builder/FileNodeTreeWriter;Lcom/desoteric/builder/AnalyticsService;)V", "run", "", "args", "", "", "([Ljava/lang/String;)V", "compiler"})
@SourceDebugExtension(value={"SMAP\nCompilerCommandLineRunner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CompilerCommandLineRunner.kt\ncom/desoteric/builder/service/CompilerCommandLineRunner\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,52:1\n1#2:53\n10468#3:54\n10890#3,2:55\n10892#3,3:61\n1563#4:57\n1634#4,3:58\n37#5,2:64\n*S KotlinDebug\n*F\n+ 1 CompilerCommandLineRunner.kt\ncom/desoteric/builder/service/CompilerCommandLineRunner\n*L\n27#1:54\n27#1:55,2\n27#1:61,3\n29#1:57\n29#1:58,3\n33#1:64,2\n*E\n"})
public class CompilerCommandLineRunner
implements CommandLineRunner {
    @NotNull
    private final ExecutionService executionService;
    @NotNull
    private final CompilerHelper compilerHelper;
    @NotNull
    private final CompilerConfigurationProperties compilerConfigurationProperties;
    @NotNull
    private final ProjectConfiguration projectConfiguration;
    @NotNull
    private final FileNodeTreeWriter fileNodeTreeWriter;
    @NotNull
    private final AnalyticsService analyticsService;

    public CompilerCommandLineRunner(@NotNull ExecutionService executionService, @NotNull CompilerHelper compilerHelper, @NotNull CompilerConfigurationProperties compilerConfigurationProperties, @NotNull ProjectConfiguration projectConfiguration, @NotNull FileNodeTreeWriter fileNodeTreeWriter, @NotNull AnalyticsService analyticsService) {
        Intrinsics.checkNotNullParameter((Object)executionService, (String)"executionService");
        Intrinsics.checkNotNullParameter((Object)compilerHelper, (String)"compilerHelper");
        Intrinsics.checkNotNullParameter((Object)compilerConfigurationProperties, (String)"compilerConfigurationProperties");
        Intrinsics.checkNotNullParameter((Object)projectConfiguration, (String)"projectConfiguration");
        Intrinsics.checkNotNullParameter((Object)fileNodeTreeWriter, (String)"fileNodeTreeWriter");
        Intrinsics.checkNotNullParameter((Object)analyticsService, (String)"analyticsService");
        this.executionService = executionService;
        this.compilerHelper = compilerHelper;
        this.compilerConfigurationProperties = compilerConfigurationProperties;
        this.projectConfiguration = projectConfiguration;
        this.fileNodeTreeWriter = fileNodeTreeWriter;
        this.analyticsService = analyticsService;
    }

    /*
     * WARNING - void declaration
     */
    public void run(String ... args) {
        void $this$toTypedArray$iv;
        void $this$flatMapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)args, (String)"args");
        this.analyticsService.sendAnalytic(Tool.COMPILER);
        LicenseValidator licenseValidator = new LicenseValidator(LicenseValidatorKt.getProductionPublicKeys());
        String string = this.projectConfiguration.getLicense();
        Intrinsics.checkNotNull((Object)string);
        if (!licenseValidator.verify(string)) {
            boolean $i$a$-check-CompilerCommandLineRunner$run$22 = false;
            String $i$a$-check-CompilerCommandLineRunner$run$22 = "You have not provided a valid license key. Visit jrecc.net to purchase a license.";
            throw new IllegalStateException($i$a$-check-CompilerCommandLineRunner$run$22.toString());
        }
        Object $this$flatMap$iv = args;
        boolean $i$f$flatMap = false;
        String[] stringArray = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        int n = ((void)$this$flatMapTo$iv$iv).length;
        for (int i = 0; i < n; ++i) {
            List list;
            void element$iv$iv;
            void arg = element$iv$iv = $this$flatMapTo$iv$iv[i];
            boolean bl = false;
            if (StringsKt.startsWith$default((String)arg, (String)"@", (boolean)false, (int)2, null)) {
                void $this$mapTo$iv$iv;
                List<String> list2 = Files.readAllLines(Path.of(StringsKt.removePrefix((String)arg, (CharSequence)"@"), new String[0]));
                Intrinsics.checkNotNullExpressionValue(list2, (String)"readAllLines(...)");
                Iterable $this$map$iv = list2;
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    String string2 = (String)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNull((Object)it);
                    collection.add(StringsKt.removeSurrounding((String)it, (CharSequence)"\""));
                }
                list = (List)destination$iv$iv2;
            } else {
                list = CollectionsKt.listOf((Object)arg);
            }
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        $this$flatMap$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        void thisCollection$iv = $this$toTypedArray$iv;
        String[] finalArgs = thisCollection$iv.toArray(new String[0]);
        if (args.length == 0) {
            this.compilerHelper.printHelp();
            return;
        }
        CommandLine commandLine = this.compilerHelper.parse(finalArgs);
        ExecutionInput input = this.compilerHelper.createExecutionInput(commandLine);
        ExecutionOutput executionOutput = this.executionService.execute(input);
        FileNodeTree fileNodeTree = (FileNodeTree)executionOutput.getOutputPaths().get(this.compilerConfigurationProperties.getOutputDirectory());
        if (fileNodeTree != null) {
            FileNodeTree it = fileNodeTree;
            boolean bl = false;
            this.fileNodeTreeWriter.write(this.compilerHelper.getOutputDirectory(commandLine), it);
        }
        System.out.print(executionOutput.getStdout());
        System.err.print(executionOutput.getStderr());
        System.exit(executionOutput.getExitCode());
        throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
    }
}

